SUBROUTINE ordena_array(array, n)
    !Ordena um array numérico em ordem crescente
    
    IMPLICIT NONE

    DOUBLE PRECISION, DIMENSION(n) :: array !Array a ser ordenado
    INTEGER :: n, i, j !Dimensão n do array e variáveis auxiliares
    DOUBLE PRECISION :: aux !Variável auxiliar
    
    !Laço que passa por todas as posições do array
    DO i = 1, (n - 1)

        !Laço que compara o número em array(i) e na posição seguinte, array(j) (j = i + 1)
        DO j = (i + 1), n
            
            IF (array(j) < array(i)) THEN
                
                !Troca os valores nos índices i e j do array, caso array(i) > array(j)
                aux = array(i)
                array(i) = array(j)
                array(j) = aux
                
            END IF

        END DO

    END DO

END SUBROUTINE ordena_array

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE coef_spline(x, y, t, a, b, c, d)
    !Dado um conjunto de t = n + 1 pontos (x, y) previamente ordenados, calcula os t coeficientes phi e t - 1 h da interpolação por spline natural para esse conjunto
    
    IMPLICIT NONE
    
    DOUBLE PRECISION, DIMENSION(t) :: x, y, a, c, l, z
    DOUBLE PRECISION, DIMENSION(t - 1) :: h, b, d, mu
    DOUBLE PRECISION, DIMENSION(t - 2) :: al
    INTEGER :: t, n, j
    
    n = t - 1
    
    
    DO j = 1, t
        a(j) = y(j)
    END DO
    
    DO j = 1, n
        h(j) = x(j+1) - x(j)
    END DO
    
    DO j = 2, n-1
        al(j) = 3./h(j) * (a(j+1) - a(j)) - 3./h(j-1) * (a(j) - a(j-1))
    END DO
    
    
    l(1) = 1
    mu(1) = 0
    z(1) = 0
    
    DO j = 2, n-1
        l(j) = 2.*(x(j+1) - x(j-1)) - h(j-1) * mu(j-1)
        mu(j) = h(j) / l(j)
        z(j) = (al(j) - h(j-1) * z(j-1)) / l(j)
    END DO
    
    l(t) = 1.
    z(t) = 0.
    c(t) = 0.
    
    DO j = n, 1, -1
    
        c(j) = z(j) - mu(j) * c(j+1)
        b(j) = (a(j+1) - a(j))/h(j) - (h(j)* (c(j+1) + 2.*c(j)))/3.
        d(j) = (c(j+1) - c(j))/(3.*h(j))
        
    END DO
    
    
END SUBROUTINE coef_spline

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE spline(x, xi, ai, bi, ci, di, polinomio)
    !DESCRIÇÃO DEPOIS

    IMPLICIT NONE

    !DOUBLE PRECISION, DIMENSION(2) :: xi, yi
    DOUBLE PRECISION :: x, xi, polinomio, ai, bi, ci, di
        
    polinomio = ai + bi * (x - xi) + ci * (x - xi) * (x - xi) + di * (x - xi) * (x - xi) * (x - xi)

END SUBROUTINE spline

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE encontra_posicao(x, abscissas, n, retorno)
    !Encontra um índice em um intervalo de abscissas (array de dimensão n) que corresponde ao valor (dentro do array) mais próximo de um x dado.
    !Retorna 0 caso x < abscissas(1), n caso x > abscissas(n) ou o índice propriamente dito, entre 1 e n-1

    IMPLICIT NONE

    DOUBLE PRECISION, DIMENSION(n), INTENT(IN) :: abscissas !Array de abscissas
    DOUBLE PRECISION :: x !Valor procurado
    INTEGER :: atual, anterior, medio, n, retorno !Índices atual, anterior e médio, dimensão do array abscissas e retorno do programa conforme estabelecido no enunciado do exercício

    !Verifica se x < x1 e retorna 0 no caso afirmativo
    IF (x < abscissas(1)) THEN
        retorno = 0

    !Verifica se x > xn e retorna n no caso afirmativo
    ELSE IF (x > abscissas(n)) THEN
        retorno = n

    !Encontra um intervalo x1 <= x <= xn e retorna o índice i do valor do array abscissas mais próximo de x
    ELSE

        atual = 2 !Começa a partir do segundo x das abscissas
        anterior = 1 !Índice anterior (metade do atual)

        !Loop busca um intervalo por caçada para fazer a bissecção
        DO WHILE ((atual * 2) <= n .AND. abscissas(anterior * 2) < x)
                           
            anterior = atual
            atual = atual * 2 !Caçada corre pelo array procurando entre xi sendo i sempre o dobro do anterior, para economizar tempo e memória

        END DO

        !Garante que a procura não pare antes de se encontrar o intervalo correto
        IF ((atual * 2) > n .AND. abscissas(atual) <= x) THEN
            
            anterior = atual
            atual = n
                
        END IF
              
        !Encontrado um intervalo, ele é refinado pelo método da bissecção
        DO WHILE (atual .NE. (anterior + 1))
        
            medio = anterior + ABS(atual - anterior) / 2
            
            IF (abscissas(medio) < x) THEN
                anterior = medio
                
            ELSE
                atual = medio
        
            END IF
        
        END DO
        
        !Checa e retorna qual o índice (atual ou anterior) contém o xi mais próximo do x desejado
        IF (ABS(abscissas(atual) - x) < ABS(abscissas(anterior) - x)) THEN
                retorno = atual
            
            ELSE
                retorno = anterior
            
        END IF

    END IF

END SUBROUTINE encontra_posicao

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

PROGRAM interp_spline
    !DESCRIÇÃO DEPOIS
    
    IMPLICIT NONE

    DOUBLE PRECISION, DIMENSION(100) :: x, polinomio
    DOUBLE PRECISION, DIMENSION(21) :: abscissas, y, phi, a, b, c, d
    DOUBLE PRECISION, DIMENSION(20) :: h
    DOUBLE PRECISION :: hi, k, ai, bi, ci, di, xi
    INTEGER :: i, retorno

    !Definindo o array x
    k = -1.
    DO i = 1, 100
    
       x(i) = k
       k = k + 0.02
       
    END DO

    !Definindo o array abscissas
    k = -1.
    DO i = 1, 21
    
       abscissas(i) = k
       k = k + 0.1
       
    END DO
    
    !Apenas para garantir que abscissas estará em ordem crescente
    CALL ordena_array(abscissas, 21)
    
    !Definindo o array y
    y = 1. / (1. + 25. * abscissas * abscissas)
    
    !Calculando arrays de coeficientes a, b, c e d
    CALL coef_spline(abscissas, y, 21, a, b, c, d)
    
    !Procedimento repetido para cada valor de x
    DO i = 1, 100
  
        !Encontrando a posicao de x no array abscissas
        CALL encontra_posicao(x(i), abscissas, 21, retorno)
    
        !Determinando arrays xi, yi, phi_i e hi com base no índice retornado pela subrotina chamada acima
        IF (abscissas(retorno) .LT. x(i) .OR. abscissas(retorno) .EQ. x(i)) THEN
            xi = abscissas(retorno)
            ai = a(retorno)
            bi = b(retorno)
            ci = c(retorno)
            di = d(retorno)
        
        ELSE IF (abscissas(retorno) .GT. x(i)) THEN
            xi = abscissas(retorno-1)
            ai = a(retorno-1)
            bi = b(retorno-1)
            ci = c(retorno-1)
            di = d(retorno-1)
    
        END IF
        
        print *, x(i)

        !Realizando spline para o valor de x dado
        CALL spline(x(i), xi, ai, bi, ci, di, polinomio(i))
    
    END DO
    
    print *,
    
    DO i = 1, 100
    
        PRINT *, polinomio(i)
    
    END DO
    
END PROGRAM interp_spline
